function NRExtImmersiveReader() {
    let self = this;
    self.readerState = 'init';
    self.frame = null;
    self.immersiveDocument = null;
    self.hasImmersiveReader = false;
    self.isVisible = false;
    self.isInjectImmersiveReader = false;
    self.changeDisplay = changeDisplay;
    self.isImmersiveTextSpacing = false;
    self.immersiveTextSize = 1;
    self.isAsyncFunction = isAsyncFunction;
    self.asyncFunctions = ['getHasImmersiveReader', 'injectImmersiveReader'];
    self.getHasImmersiveReader = getHasImmersiveReader;
    self.injectImmersiveReader = injectImmersiveReader;
    self.setTexts = setTexts;
    const elementIds = {
        immersiveReader: 'nr-immersive-reader',
        textSettingsButton: 'immersive_trigger',
        closeImmersiveButton: 'immersive_close',
        textSpacingToggle: 'nr-immersive-text-spacing-toggle',
        textSizeSlider: 'nr-ext-textsize',
        textSizeValueSender: 'nr-ext-textsize-value-sender',
        textContainer: 'nr-immersive-reader-text-container',
        textContent: 'nr-immersive-reader-text',
        textSpacingToggle: 'nr-immersive-text-spacing-toggle',
        textSettingsMenu: 'immersive_menu',
        immersiveDyslexiaToggle: 'toggle-dyslexia',
        nextPageButton: 'immersive_next_page',
        prevPageButton: 'immersive_prev_page',
        totalPages: 'immersive_all_page',
        pagesToolbar: 'nr-immersive-reader-pages',
        currentPageInput: 'immersive_current_page',
    }
    function initImmersiveElements() {
        return new Promise((resolve) => {
            for (let id in elementIds) {
                self[id] = self.immersiveDocument.getElementById(elementIds[id]);
            }
            resolve();
        })
            .catch((err) => {
            });
    }
    async function init() {
        try {
            await initImmersiveElements();
            if (typeof nrExtWidget != 'undefined') {
                const theme = nrExtWidget.isDarkTheme ? 'dark' : 'light';
                $(self.immersiveDocument.body).attr('data-theme', theme);
            }
            self.textSettingsButton.onclick = () => {
                toggleMenu();
            }
            self.closeImmersiveButton.onclick = () => {
                if (typeof nrExtWidget != 'undefined') {
                    nrExtWidget.toggleImmersive();
                }
            }
            chrome.runtime.sendMessage({fn: 'getWidgetSettings'}, async (widgetSettings) => {
                self.isImmersiveTextSpacing = widgetSettings.isImmersiveTextSpacing;
                self.immersiveTextSize = widgetSettings.immersiveTextSize;
                setTextSpacing(self.isImmersiveTextSpacing);
                setTextSize(self.immersiveTextSize, false);
            });
            self.textSpacingToggle.onclick = () => {
                setTextSpacing(!self.isImmersiveTextSpacing);
            }
            $(self.textContent).attr('text-scale', self.immersiveTextSize);
            self.textSizeValueSender.onchange = () => {
                self.immersiveTextSize = self.textSizeValueSender.value;
                nrExtWidget.setWidgetSetting('immersiveTextSize', self.immersiveTextSize);
            }
            if (typeof doc != 'undefined' && (doc.type === 'googleDoc' || doc.type === 'googleDrivePreview')) {
                self.prevPageButton.style.display = 'block';
                self.nextPageButton.style.display = 'block';
                self.pagesToolbar.style.display = 'flex';
                const numPages = doc.getPages().length;
                self.totalPages.innerText = numPages;
                self.currentPageInput.value = doc.getPageIndex();
                self.currentPageInput.max = numPages;
                $(self.currentPageInput).on('keyup', function(e) {
                    if (e.key === 'Enter' || e.keyCode === 13) {
                        const inputVal = self.currentPageInput.value;
                        if (inputVal && (inputVal >= 1 && inputVal <= numPages)) {
                            switchPage(inputVal - 1);
                        } else {
                            self.currentPageInput.value = doc.getPageIndex() + 1;
                        }
                    }
                });
                checkDisableChangePageButtons();
                self.prevPageButton.onclick = debounce(() => {
                    switchPage(doc.getPageIndex() - 1)
                });
                self.nextPageButton.onclick = debounce(
                    () => {
                        switchPage(doc.getPageIndex() + 1);
                    });
            }
            function initTooltip(elem, direction, text) {
                let tooltip = setTooltip(elem, direction, text);
                elem.onmouseenter = function() {
                    if (elem.id === 'nr-ext-btn-relocate' && self.mode === 'min') {
                        return;
                    }
                    tooltip.style.display = "block";
                    tooltip.style.visibility = "visible";
                };
                elem.onmouseleave = function() {
                    tooltip.style.display = "none";
                };
                tooltip.onmouseenter = function() {
                    tooltip.style.display = "none";
                };
            }
        } catch (err) {
        }
    }
    function switchPage(pageIndex) {
        chrome.runtime.sendMessage({fn: 'getReaderInfo'}, function(info) {
            if (chrome.runtime.lastError) {
            }
            if (info.readerState === 'reading') {
                chrome.runtime.sendMessage({message: 'readPage', pageIndex}, () => void chrome.runtime.lastError);
            } else {
                if (doc.scrollToPage) {
                    return doc.scrollToPage(pageIndex)
                        .then(resp => {
                            chrome.runtime.sendMessage({fn: 'setTextsForTtsWithoutPlay'}, function() {
                                if (chrome.runtime.lastError) {
                                }
                            });
                        });
                }
            }
        });
    }
    function checkDisableChangePageButtons() {
        const currPageIndex = doc.getPageIndex();
        self.currentPageInput.value = currPageIndex + 1;
        if (currPageIndex === 0) {
            self.prevPageButton.disabled = true;
        } else {
            self.prevPageButton.disabled = false;
        }
        if (currPageIndex >= doc.getPages().length - 1 || currPageIndex == -1) {
            self.nextPageButton.disabled = true;
        } else {
            self.nextPageButton.disabled = false;
        }
    }
    function setTextSize(value, shouldSetWidgetSetting = true) {
        self.textSizeValueSender.value = value;
        const event = new Event('change');
        self.textSizeValueSender.dispatchEvent(event);
        $(self.textContent).attr('text-scale', value);
        if (shouldSetWidgetSetting) {
            nrExtWidget.setWidgetSetting('immersiveTextSize', value);
        }
    }
    function setTextSpacing(val) {
        self.isImmersiveTextSpacing = val;
        if (self.isImmersiveTextSpacing) {
            $(self.textSpacingToggle).attr('toggle-status', 'on');
            self.textContainer.classList.add("nr-text-spacing");
        } else {
            $(self.textSpacingToggle).attr('toggle-status', 'off');
            self.textContainer.classList.remove("nr-text-spacing");
        }
        nrExtWidget.setWidgetSetting("isImmersiveTextSpacing", self.isImmersiveTextSpacing);
    }
    function isAsyncFunction(fnName) {
        return self.asyncFunctions.includes(fnName);
    }
    function getHasImmersiveReader() {
        sendResponse(self.hasImmersiveReader);
    }
    function injectImmersiveReader() {
        if (!self.isInjectImmersiveReader && !self.hasImmersiveReader) {
            self.isInjectImmersiveReader = true;
            let iframe = document.createElement('iframe');
            self.frame = iframe;
            self.frame.id = "nr-ext-immersive-reader";
            self.frame.style.background = "none";
            self.frame.style.backgroundColor = "transparent";
            self.frame.style.zIndex = "12345678";
            self.frame.style.right = 0;
            self.frame.style.top = 0;
            self.frame.style.overflow = "hidden";
            self.frame.style.position = "fixed";
            self.frame.style.height = "100%";
            self.frame.style.width = "100%";
            self.frame.style.display = "none";
            document.body.appendChild(iframe);
            self.frame.onload = async () => {
                await frameContentOnLoad();
                setTexts();
            }
            fetch(chrome.runtime.getURL("injected/nr-ext-immersive-reader/nr-ext-immersive-reader.html"))
                .then((response) => {
                    return response.text();
                })
                .then((immersiveReader) => {
                    try {
                        self.frame.contentDocument.write(immersiveReader);
                        self.immersiveDocument = self.frame.contentDocument;
                        self.frame.contentDocument.close();
                    } catch (err) {
                        self.frame.contentDocument.close();
                    };
                }).catch(err => {
                });
        }
    }
    async function frameContentOnLoad() {
        await loadResource(null, chrome.runtime.getURL('assets/css/ion.rangeSlider.css'));
        await loadResource(null, chrome.runtime.getURL('assets/js/jquery-3.6.0.min.js'));
        await loadResource(null, chrome.runtime.getURL('assets/css/bootstrap.min.css'));
        await loadResource(null, chrome.runtime.getURL('assets/js/bootstrap.bundle.min.js'));
        await loadResource(null, chrome.runtime.getURL('injected/nr-ext-immersive-reader/nr-ext-immersive-reader.css'));
        await loadResource(null, chrome.runtime.getURL('assets/js/ion.rangeSlider.min.js'));
        await loadResource(null, chrome.runtime.getURL('injected/nr-ext-immersive-reader/slider-init.js'));
        await init();
        self.frame.style.display = "block";
    }
    function loadResource(type, url) {
        return new Promise((resolve, reject) => {
            let tag;
            if (!type) {
                let match = url.match(/\.([^.]+)$/);
                if (match) {
                    type = match[1];
                }
            }
            if (!type) {
                type = "js";
            }
            if (type === 'css') {
                tag = document.createElement("link");
                tag.type = 'text/css';
                tag.rel = 'stylesheet';
                tag.href = url;
                self.immersiveDocument.head.appendChild(tag);
            }
            else if (type === "js") {
                tag = document.createElement("script");
                tag.type = "text/javascript";
                tag.src = url;
                self.immersiveDocument.body.appendChild(tag);
            }
            if (tag) {
                tag.onload = () => {
                    resolve(url);
                };
                tag.onerror = () => {
                    reject(url);
                };
            }
        })
            .catch((err) => {
            });
    }
    function toggleMenu() {
        const isMenuOpen = $(self.immersiveReader).attr('menu-status') === 'open';
        if (isMenuOpen) {
            $(self.textSettingsMenu).fadeOut('fast');
            $(self.immersiveReader).attr('menu-status', 'close');
        } else {
            $(self.textSettingsMenu).fadeIn('fast');
            $(self.immersiveReader).attr('menu-status', 'open');
        }
    }
    function changeDisplay(toShow) {
        if (toShow) {
            if (typeof nrTextProcessor != 'undefined') {
                if (nrTextProcessor.isSameText()) {
                    self.frame.style.display = 'block';
                } else {
                    clearTexts();
                    chrome.runtime.sendMessage({fn: 'setTextsForTtsWithoutPlay'}, function() {
                        if (chrome.runtime.lastError) {
                        }
                        self.frame.style.display = 'block';
                        return setTexts();
                    });
                }
            }
        } else {
            self.frame.style.display = 'none';
        }
    }
    function setTexts() {
        clearTexts();
        if (doc.type != 'googleDoc' && doc.type != 'googleDrivePreview') {
            doc.parseForConvertToPdf()
                .then(function(elements) {
                    return setTextsHelper(elements);
                })
                .then(() => {
                    initDyslexiaFont();
                    self.prevPageButton.style.display = 'block';
                    self.nextPageButton.style.display = 'block';
                    checkDisableChangePageButtons();
                })
                .catch(err => {
                });
        } else {
            return Promise.resolve()
                .then(() => {
                    if (doc.type == 'googleDoc') {
                        doc.parsePageForImmersiveReader()
                            .then(function(elements) {
                                return setTextsHelper(elements);
                            })
                    } else {
                        return setTextsForGoogleDrivePreview();
                    }
                })
                .then(() => {
                    initDyslexiaFont();
                    const numPages = doc.getPages().length;
                    self.totalPages.innerText = numPages;
                    self.currentPageInput.value = doc.getPageIndex();
                    self.prevPageButton.style.display = 'block';
                    self.nextPageButton.style.display = 'block';
                    checkDisableChangePageButtons();
                })
                .catch(err => {
                });
        }
    }
    function clearTexts() {
        $(self.textContainer).empty();
    }
    function setTextsForGoogleDrivePreview() {
        const texts = nrTextProcessor.textsToRead;
        const pageIndex = doc.getCurrentIndex();
        for (let i = 0; i < texts.length; i++) {
            sentenceId = 'nr-immersive-s' + i;
            const p = document.createElement("P");
            const nrSentece = document.createElement('nr-sentence');
            const textNode = document.createTextNode(texts[i]);
            nrSentece.classList.add(sentenceId);
            nrSentece.id = sentenceId;
            nrSentece.setAttribute("page", pageIndex);
            nrSentece.appendChild(textNode);
            p.appendChild(nrSentece);
            nrDomController.bindClickToReadEventsForImmersiveReader(nrSentece, self.tabId, self.immersiveDocument);
            self.textContainer.appendChild(p);
        }
    }
    function setTextsHelper(elements) {
        return new Promise((resolve) => {
            for (let i = 0; i < elements.length; i++) {
                const element = elements[i];
                let parent = null;
                if (element.tagName.toLowerCase() === 'h1') {
                    parent = document.createElement("H1");
                    parent.classList.add("nr-immersive-heading1");
                } else if (element.tagName.toLowerCase() === 'h2') {
                    parent = document.createElement("H2");
                    parent.classList.add("nr-immersive-heading2");
                } else {
                    parent = document.createElement('P');
                }
                const nrSentences = Array.from(element.querySelectorAll("nr-sentence"));
                let currSentenceIndex = -1;
                for (let j = 0; j < nrSentences.length; j++) {
                    const classes = nrSentences[j].classList;
                    let sentenceIndex = -1;
                    for (let k = 0; k < classes.length; k++) {
                        if (classes[k].includes("nr-s")) {
                            sentenceIndex = parseInt(classes[k].split("nr-s")[1]);
                            break;
                        }
                    }
                    if (currSentenceIndex != sentenceIndex) {
                        const text = nrTextProcessor.textsToRead[sentenceIndex];
                        const clone = nrSentences[j].cloneNode(true);
                        $(clone).empty();
                        const textNode = document.createTextNode(text);
                        clone.appendChild(textNode);
                        clone.removeAttribute('class');
                        sentenceId = 'nr-immersive-s' + sentenceIndex;
                        clone.classList.add(sentenceId);
                        clone.id = sentenceId;
                        nrDomController.bindClickToReadEventsForImmersiveReader(clone, self.tabId, self.immersiveDocument);
                        parent.appendChild(clone);
                        parent.appendChild(document.createTextNode(" "));
                        self.textContainer.appendChild(parent);
                        currSentenceIndex = sentenceIndex;
                    }
                }
            }
            resolve();
        })
            .catch(err => {
            });
    }
    function initDyslexiaFont() {
        if (typeof nrExtWidget != 'undefined') {
            self.immersiveDyslexiaToggle.onclick = () => {
                nrExtWidget.setDyslexia(!nrExtWidget.isDyslexic);
            }
            if (nrExtWidget.isDyslexic) {
                self.textContainer.classList.add('dyslexicfonts');
                nrExtWidget.setToggle(true, self.immersiveDyslexiaToggle);
            }
        }
    }
    chrome.runtime.onMessage.addListener(function(request, sender, sendResponse) {
        if (request.fn in nrExtImmersiveReader) {
            nrExtImmersiveReader[request.fn](request, sender, sendResponse);
            if (request.tabId) {
                self.tabId = request.tabId;
            }
            if (nrExtImmersiveReader.isAsyncFunction(request.fn)) {
                return true;
            }
        }
    });
    function replaceSpecialWhiteSpaces(text) {
        var cleanedText = text.replace(/\u200C/g, ' ');
        var nonBreakingSpaces = String.fromCharCode(160);
        var regex = new RegExp(nonBreakingSpaces, 'g');
        cleanedText = cleanedText.replace(regex, ' ');
        return cleanedText;
    }
}
var nrExtImmersiveReader = nrExtImmersiveReader || new NRExtImmersiveReader();